define(['./_baseFlatten', './_baseUniq', './rest'], function(baseFlatten, baseUniq, rest) {

  'use strict';

  /**
   * Creates an array of unique values, in order, from all given arrays using
   * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
   * for equality comparisons.
   *
   * @static
   * @memberOf _
   * @category Array
   * @param {...Array} [arrays] The arrays to inspect.
   * @returns {Array} Returns the new array of combined values.
   * @example
   *
   * _.union([2, 1], [4, 2], [1, 2]);
   * // => [2, 1, 4]
   */
  var union = rest(function(arrays) {
    return baseUniq(baseFlatten(arrays, 1, true));
  });

  return union;
});
